const express = require('express');
const cors = require('cors');
const db = require('./models');
const path = require('path');

const app = express();
const PORT = process.env.PORT || 5000;

app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Folder upload gambar
app.use('/uploads', express.static(path.join(__dirname, 'uploads')));

// --- IMPORT ROUTES (Cek bagian ini) ---
const authRoutes = require('./routes/auth.routes');
const userRoutes = require('./routes/user.routes');
const productRoutes = require('./routes/product.routes');
const orderRoutes = require('./routes/order.routes'); 


// --- GUNAKAN ROUTES (Cek bagian ini) ---
app.use('/api/auth', authRoutes);
app.use('/api/test', userRoutes);
app.use('/api/products', productRoutes);
app.use('/api/orders', orderRoutes); 
// ---------------------------------------

db.sequelize.sync()
  .then(() => {
    app.listen(PORT, () => {
      console.log(`Server is running on port ${PORT}.`);
    });
  })
  .catch((err) => {
    console.error("Failed to sync database: " + err.message);
  });