const express = require('express');
const router = express.Router();
const authJwt = require('../middleware/authJwt');
const db = require('../models');
const User = db.User;

// --- A. AKSES PUBLIK (Siapa saja boleh akses) ---
router.get('/all', (req, res) => {
  res.status(200).send("Konten Publik. Siapapun bisa melihat ini.");
});

// --- B. AKSES USER LOGIN (Harus punya Token) ---
// Middleware 'verifyToken' dipasang sebelum function handler
router.get('/profile', [authJwt.verifyToken], async (req, res) => {
  try {
    // req.userId sudah tersedia berkat middleware verifyToken
    const user = await User.findByPk(req.userId);
    
    res.status(200).json({
      message: "Ini profil Anda (Protected Content).",
      user: {
        id: user.id,
        username: user.username,
        full_name: user.full_name,
        role: user.role
      }
    });
  } catch (err) {
    res.status(500).json({ message: err.message });
  }
});

// --- C. AKSES KHUSUS KASIR ---
// Harus Token Valid DAN Role = 'cashier'
router.get('/cashier-panel', [authJwt.verifyToken, authJwt.isCashier], (req, res) => {
  res.status(200).send("Selamat Datang di Panel Kasir.");
});

// --- D. AKSES KHUSUS DAPUR ---
// Harus Token Valid DAN Role = 'kitchen'
router.get('/kitchen-panel', [authJwt.verifyToken, authJwt.isKitchen], (req, res) => {
  res.status(200).send("Selamat Datang di Panel Dapur.");
});

module.exports = router;