const express = require('express');
const router = express.Router();
const productController = require('../controllers/product.controller');
// IMPORT CONTROLLER BARU KITA
const reviewController = require('../controllers/review.controller'); 
const authJwt = require('../middleware/authJwt');
const upload = require('../middleware/upload');

// Public Routes
router.get('/', productController.getAllProducts);
router.get('/:id', productController.getProductById);

// Protected Routes (Kitchen - Manajemen Produk)
router.post('/', [authJwt.verifyToken, authJwt.isKitchen, upload.single('image')], productController.createProduct);
router.put('/:id', [authJwt.verifyToken, authJwt.isKitchen, upload.single('image')], productController.updateProduct);
router.delete('/:id', [authJwt.verifyToken, authJwt.isKitchen], productController.deleteProduct);

// --- REVIEW ROUTE [BARU] ---
// Endpoint: POST /api/products/review
router.post(
  '/review', 
  [authJwt.verifyToken], // Harus login untuk review
  reviewController.createReview
);

module.exports = router;