const express = require('express');
const router = express.Router();
const orderController = require('../controllers/order.controller');
const authJwt = require('../middleware/authJwt');

// --- KASIR ROUTES ---
router.post('/', [authJwt.verifyToken], orderController.createOrder); // *Catatan: Jika User Online juga order lewat sini, middleware isCashier harus disesuaikan atau buat endpoint terpisah. Lihat catatan bawah.
router.get('/history', [authJwt.verifyToken, authJwt.isCashier], orderController.getCashierHistory);

// --- DAPUR ROUTES ---
router.get('/kitchen', [authJwt.verifyToken, authJwt.isKitchen], orderController.getKitchenOrders);
router.put('/:id/status', [authJwt.verifyToken], orderController.updateStatus);

// --- USER (PELANGGAN) ROUTES [BARU] ---
// Endpoint: GET /api/orders/my-orders
router.get(
  '/my-orders', 
  [authJwt.verifyToken], // Cukup verifyToken, tidak perlu isCashier/isKitchen
  orderController.getUserHistory
);

// *REVISI PENTING UNTUK CREATE ORDER*:
// Agar User Online BISA order, kita harus melonggarkan rute POST '/' 
// atau membuat rute khusus. Mari kita perbarui rute POST '/' agar fleksibel:
router.post(
  '/', 
  [authJwt.verifyToken], // Hapus 'isCashier' agar User biasa juga bisa order
  orderController.createOrder
);

module.exports = router;