// Path: /doughnote-backend/models/user.model.js

const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const User = sequelize.define('User', {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true
    },
    username: {
      type: DataTypes.STRING,
      allowNull: false,
      unique: true
    },
    password: {
      type: DataTypes.STRING,
      allowNull: false
    },
    full_name: {
      type: DataTypes.STRING,
      allowNull: false
    },
    email: {
      type: DataTypes.STRING,
      unique: true,
      validate: {
        isEmail: true
      }
    },
    phone: {
      type: DataTypes.STRING
    },
    address: {
      type: DataTypes.TEXT
    },
    role: {
      type: DataTypes.ENUM('user', 'cashier', 'kitchen'),
      allowNull: false
    }
  }, {
    tableName: 'users',
    timestamps: true, // Otomatis menambah created_at dan updated_at
    createdAt: 'created_at',
    updatedAt: false // Kita tidak perlu updated_at di tabel user
  });
  
  return User;
};