// Path: /doughnote-backend/models/orderItem.model.js

const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const OrderItem = sequelize.define('OrderItem', {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true
    },
    quantity: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    price_per_item: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false
    }
    // order_id dan product_id akan ditambahkan otomatis oleh Asosiasi
  }, {
    tableName: 'order_items',
    timestamps: false // Tabel penghubung biasanya tidak perlu timestamp
  });

  return OrderItem;
};