const { DataTypes } = require('sequelize');

module.exports = (sequelize) => {
  const Order = sequelize.define('Order', {
    // ... field lama (id, total_price, dll) tetap sama ...
    
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    total_price: { type: DataTypes.DECIMAL(10, 2), allowNull: false },
    status: { 
      type: DataTypes.ENUM('pending', 'paid', 'processing', 'completed', 'cancelled'),
      defaultValue: 'pending' 
    },
    order_type: { type: DataTypes.ENUM('online', 'in-person'), allowNull: false },
    
    // --- TAMBAHAN BARU ---
    customer_name: {
      type: DataTypes.STRING,
      defaultValue: 'Pelanggan Umum'
    },
    payment_method: {
      type: DataTypes.ENUM('cash', 'qris'),
      defaultValue: 'cash'
    },
    // Tambahkan di dalam definisi Order (seperti sebelumnya)
    delivery_method: {
      type: DataTypes.ENUM('pickup', 'delivery'),
      defaultValue: 'pickup'
    },
    delivery_address: {
      type: DataTypes.TEXT, // Alamat jika delivery
      allowNull: true
    }
    // ---------------------
  }, {
    tableName: 'orders',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
  });

  return Order;
};