const sequelize = require('../config/database');
const { Sequelize } = require('sequelize');

// Siapkan objek 'db' untuk menampung semua model
const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

// Import dan inisialisasi semua model
db.User = require('./user.model.js')(sequelize, Sequelize);
db.Product = require('./product.model.js')(sequelize, Sequelize);
db.Order = require('./order.model.js')(sequelize, Sequelize);
db.OrderItem = require('./orderItem.model.js')(sequelize, Sequelize);
db.Review = require('./review.model.js')(sequelize, Sequelize);

// --- MULAI DEFINISI RELASI ---

// Relasi User -> Order (Satu User bisa punya banyak Order)
// 1. Sebagai Pelanggan (user_id)
db.User.hasMany(db.Order, { foreignKey: 'user_id', as: 'customerOrders' });
db.Order.belongsTo(db.User, { foreignKey: 'user_id', as: 'customer' });

// 2. Sebagai Kasir (cashier_id)
db.User.hasMany(db.Order, { foreignKey: 'cashier_id', as: 'cashierOrders' });
db.Order.belongsTo(db.User, { foreignKey: 'cashier_id', as: 'cashier' });

// Relasi Order <-> Product (Many-to-Many melalui OrderItem)
db.Order.belongsToMany(db.Product, {
  through: db.OrderItem,
  foreignKey: 'order_id'
});
db.Product.belongsToMany(db.Order, {
  through: db.OrderItem,
  foreignKey: 'product_id'
});

// Relasi langsung ke tabel penghubung (jika perlu)
db.Order.hasMany(db.OrderItem, { foreignKey: 'order_id' });
db.OrderItem.belongsTo(db.Order, { foreignKey: 'order_id' });

db.Product.hasMany(db.OrderItem, { foreignKey: 'product_id' });
db.OrderItem.belongsTo(db.Product, { foreignKey: 'product_id' });


// RELASI REVIEW
// 1. User menulis banyak review
db.User.hasMany(db.Review, { foreignKey: 'user_id' });
db.Review.belongsTo(db.User, { foreignKey: 'user_id' });

// 2. Produk punya banyak review
db.Product.hasMany(db.Review, { foreignKey: 'product_id' });
db.Review.belongsTo(db.Product, { foreignKey: 'product_id' });

// 3. Review terikat ke Order (untuk memastikan user sudah beli)
db.Order.hasOne(db.Review, { foreignKey: 'order_id' });
db.Review.belongsTo(db.Order, { foreignKey: 'order_id' });

// --- SELESAI DEFINISI RELASI ---

module.exports = db;