const multer = require('multer');
const path = require('path');

// Konfigurasi penyimpanan file
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    // Simpan di folder 'uploads' di root project
    cb(null, 'uploads/');
  },
  filename: (req, file, cb) => {
    // Format nama file: timestamp-namaasli.jpg (biar unik)
    cb(null, Date.now() + path.extname(file.originalname));
  }
});

// Filter agar hanya bisa upload gambar
const fileFilter = (req, file, cb) => {
  const allowedTypes = /jpeg|jpg|png|gif/;
  const extname = allowedTypes.test(path.extname(file.originalname).toLowerCase());
  const mimetype = allowedTypes.test(file.mimetype);

  if (mimetype && extname) {
    return cb(null, true);
  } else {
    cb('Error: Hanya boleh upload gambar (jpeg, jpg, png, gif)!');
  }
};

const upload = multer({ 
  storage: storage,
  limits: { fileSize: 5 * 1024 * 1024 }, // Maksimal 5MB
  fileFilter: fileFilter
});

module.exports = upload;