const jwt = require('jsonwebtoken');
const db = require('../models');
const User = db.User;
require('dotenv').config();

// 1. Fungsi Cek Token
const verifyToken = (req, res, next) => {
  // Ambil token dari header (bisa 'x-access-token' atau 'Authorization')
  let token = req.headers['x-access-token'] || req.headers['authorization'];

  if (!token) {
    return res.status(403).json({ message: 'Akses ditolak! Token tidak ditemukan.' });
  }

  // Jika formatnya "Bearer <token>", kita ambil tokennya saja
  if (token.startsWith('Bearer ')) {
    token = token.slice(7, token.length);
  }

  // Verifikasi token
  jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
    if (err) {
      return res.status(401).json({ message: 'Token tidak valid atau kadaluwarsa!' });
    }

    // Simpan ID user dari token ke dalam request agar bisa dipakai di controller
    req.userId = decoded.id;
    
    // Lanjut ke proses berikutnya
    next();
  });
};

// 2. Fungsi Cek Role: KASIR
const isCashier = async (req, res, next) => {
  try {
    const user = await User.findByPk(req.userId);
    if (user.role === 'cashier') {
      next(); // Boleh lewat
      return;
    }
    res.status(403).json({ message: 'Hanya Kasir yang boleh mengakses ini!' });
  } catch (err) {
    res.status(500).json({ message: 'Gagal memverifikasi role user.' });
  }
};

// 3. Fungsi Cek Role: DAPUR
const isKitchen = async (req, res, next) => {
  try {
    const user = await User.findByPk(req.userId);
    if (user.role === 'kitchen') {
      next(); // Boleh lewat
      return;
    }
    res.status(403).json({ message: 'Hanya Dapur yang boleh mengakses ini!' });
  } catch (err) {
    res.status(500).json({ message: 'Gagal memverifikasi role user.' });
  }
};

// Export fungsi-fungsi ini agar bisa dipakai di routes
const authJwt = {
  verifyToken,
  isCashier,
  isKitchen
};

module.exports = authJwt;