const db = require('../models');
const Review = db.Review;
const Order = db.Order;

exports.createReview = async (req, res) => {
  try {
    const { product_id, order_id, rating, comment } = req.body;
    const user_id = req.userId; // Didapat dari middleware verifyToken

    // 1. Validasi: Pastikan Rating ada
    if (!rating || rating < 1 || rating > 5) {
      return res.status(400).json({ message: "Rating harus antara 1 sampai 5." });
    }

    // 2. Validasi Keamanan:
    // Cek apakah User BENAR-BENAR membeli produk ini dan statusnya sudah SELESAI.
    // Kita tidak ingin orang sembarangan memberi review tanpa membeli.
    const order = await Order.findOne({ 
      where: { 
        id: order_id, 
        user_id: user_id, 
        status: 'completed' // Hanya boleh review jika pesanan sudah selesai
      } 
    });

    if (!order) {
      return res.status(403).json({ 
        message: "Anda tidak dapat mengulas. Pesanan belum selesai atau tidak valid." 
      });
    }

    // 3. Cek apakah sudah pernah review (Opsional, agar tidak spam)
    const existingReview = await Review.findOne({
      where: { order_id: order_id, product_id: product_id }
    });

    if (existingReview) {
      return res.status(400).json({ message: "Anda sudah mengulas produk ini pada pesanan tersebut." });
    }

    // 4. Buat Review
    await Review.create({
      user_id,
      product_id,
      order_id,
      rating,
      comment
    });

    res.status(201).json({ message: "Terima kasih! Ulasan Anda berhasil dikirim." });

  } catch (err) {
    console.error(err);
    res.status(500).json({ message: "Gagal mengirim ulasan: " + err.message });
  }
};